local gc = Var("GameCommand");
local idx = gc:GetIndex()+1;

local kanji = {
	"game",
	"edit",
	"option",
	"quit",
};

local deco = {
	"game",
	"edit",
	"option",
	"quit",
};

local sideTexts = {
	Game	= { Left = "Quit", Right = "Edit" };
	Edit	= { Left = "Game", Right = "Menu" };
	Option	= { Left = "Edit", Right = "Quit" };
	Quit	= { Left = "Menu", Right = "Game" };
}

return Def.ActorFrame {
	LoadFont("ScreenTitleMenu side") .. {
		Name="Left";
		InitCommand=cmd(x,-164;y,-35;uppercase,true;halign,.5;zoom,.7);
		GainFocusCommand=cmd(settext,sideTexts[gc:GetName()].Left;zoomx,.8;accelerate,0.05;diffusealpha,0.8;zoomx,.7);
		LoseFocusCommand=cmd(stoptweening;accelerate,0.1;diffusealpha,0);
	};
	LoadFont("ScreenTitleMenu side") .. {
		Name="Right";
		InitCommand=cmd(x,164;y,-35;uppercase,true;halign,.5;zoom,.7);
		GainFocusCommand=cmd(settext,sideTexts[gc:GetName()].Right;zoomx,.8;accelerate,0.05;diffusealpha,0.8;zoomx,.7);					
		LoseFocusCommand=cmd(stoptweening;accelerate,0.1;diffusealpha,0);
	};
	LoadActor("_deco "..deco[idx])..{
		InitCommand=cmd();
		GainFocusCommand=cmd(stoptweening;glow,color("1,1,1,1");rotationz,120;zoom,.3;decelerate,0.2;glow,color("1,1,1,0");zoom,1;rotationz,0);
		LoseFocusCommand=cmd(stoptweening;zoom,0);
	};
	LoadActor("_kanji "..kanji[idx])..{
		InitCommand=cmd();
		GainFocusCommand=cmd(stoptweening;zoom,1.1;glow,color("1,1,1,1");linear,0.1;glow,color("1,1,1,0");zoom,1);
		LoseFocusCommand=cmd(stoptweening;zoom,0);
	};
};